﻿<%@ Page Title="Lab Order" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabOrder.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabOrder" %>

<%@ Register src="~/Controls/Custom/EFR/FromToDate.ascx" tagname="FromToDate" tagprefix="UserControlFromToDate" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">         
</asp:Content> 

<asp:Content ID="Content2" ContentPlaceHolderID = "MainContent" Runat="Server">

    <script type ="text/javascript">
        $(document).ready(function()
        {
            $('input[id*=AnalytesList]').click(function()
            {
                // check if the label following the checkbox  is 'All'
                if ($('label[for="' + $(this).attr('id') + '"]').text() == 'All')
                {
                    if ($(this).is(':checked'))
                    {
                        $(this).closest('table').find(':checkbox').attr('checked', true);
                    }
                    else
                    {
                        $(this).closest('table').find(':checkbox').attr('checked', false);
                    }
                }
            });

            if ($('#<%=OtherAnalyteCheck.ClientID %>').is(':checked'))
            {
                $('#<%=OtherAnalyteText.ClientID %>').removeAttr('disabled');
            }
            else
            {
                $('#<%=OtherAnalyteText.ClientID %>').attr('disabled', 'disabled');
            }

            $('#<%=OtherAnalyteCheck.ClientID %>').click(function()
            {
                if ($(this).is(':checked'))
                {
                    $('#<%=OtherAnalyteText.ClientID %>').removeAttr('disabled');
                    $('#<%=OtherAnalyteText.ClientID %>').focus();
                }
                else
                {
                    $('#<%=OtherAnalyteText.ClientID %>').attr('disabled', 'disabled');
                    $('#<%=OtherAnalyteText.ClientID %>').val('');
                }
            });
        });
    
    </script>
      
    <asp:ObjectDataSource ID="ObjectDataSourceOrderStatus" runat="server" 
        OnSelecting="Ds_Selecting"
        SelectMethod="GetOrderStatusByActivityID" 
        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "activityId" Direction = "Input" Name = "activityid" /> 
            </SelectParameters>
    </asp:ObjectDataSource> 
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
        OnSelecting="Ds_Selecting"
        SelectMethod="GetPatientByActivityId" 
        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "activityId" Direction = "Input" Name = "activityid" /> 
            </SelectParameters>       
     </asp:ObjectDataSource>

<%--    <div class="breadcrumb">
          
        <asp:FormView ID="FormViewWorkflowInformation" runat="server" DataSourceID="ObjectDataSourceOrderStatus">
            <ItemTemplate>
              <asp:Label SkinID="DataLabel" ID = "LabelWorkflowInformation" runat="server" Text='<%# "Workflow ID " + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Key"))) %>'  />
              <br />
            </ItemTemplate>
        </asp:FormView>
         
    </div>--%>

    <br />

    <asp:ValidationSummary ID="ValidationSummaryLabOrderValidation" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="LabOrderValidation"
        ShowMessageBox="True" />

    <table>
        <tr>
            <td>
            <asp:FormView ID="FormViewPatientInformation" runat="server"  
                DataSourceID="ObjectDataSourcePatient" Width="100%" DataKeyNames = "PatientId" 
                CellPadding="4" ForeColor="#333333">
                <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                <ItemTemplate>
                    
                    <asp:Panel ID="PanelPatient" runat="server" GroupingText="&nbsp;&nbsp;Patient Information&nbsp;&nbsp;" Width = "100%" >

                    <br />

                    <table cellpadding="-1" cellspacing="10" width="100%">
                    <tr style = "width:100%;" >
                        <td align= "left"> 
                         <table border = "0px">
                            <tr style = "height:20px;" >
                                <td align = "left" style = "width:100px;">
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID="LabelName" runat="server" Text="Name:" AssociatedControlID="NameLabel"></asp:Label>
                                </td>
                                <td> 
                                    <asp:Label SkinID="DataLabel" ID="NameLabel" runat="server"  Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>' />
                                </td>
                            </tr>
                             
                            <tr style = "height:20px;" >
                                <td align = "left" style = "width:125px;">   
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID="LabelBranch" runat="server" Text="Service Branch:" AssociatedControlID="SBranchLabel"></asp:Label>
                                </td> 
                                <td>
                                    <asp:Label SkinID="DataLabel" ID = "SBranchLabel" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientServiceBranch"))) %>'  />
                                
                                </td>
                              </tr>
                             <tr style = "height:20px;" >
                                    <td align = "left" style = "width:125px;">
                                        &nbsp;
                                        <asp:Label SkinID="DataLabel" ID="LabelStatus" runat="server" Text="Service Status:" AssociatedControlID="StatusLabel"></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label SkinID="DataLabel" ID="StatusLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientServiceStatus")))%>' />
                                    </td>
                                </tr>
                              </table> 
                           </td>
                           <td>
                            <table border = "0px">
                                <tr style = "height:20px;" >
                                    <td align = "left" style = "width:100px;">
                                        &nbsp;
                                        <asp:Label SkinID="DataLabel" ID="LabelSSN" runat="server" Text="SSN:" AssociatedControlID="SSNLabel"></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label SkinID="DataLabel" ID="SSNLabel" runat="server"  Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientSSN"))) %>' />
                                    </td>
                                </tr>
                                
                                <tr style = "height:20px;" >
                                    <td align = "left" style = "width:125px;">
                                        &nbsp;
                                        <asp:Label SkinID="DataLabel" ID="LabelICN" runat="server" Text="ICN:" AssociatedControlID="ICNLabel"></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label SkinID="DataLabel" ID="ICNLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientIcn")))%>' />
                                    </td>
                                </tr>
                                <tr style = "height:20px;" >
                                    <td align = "left" style = "width:100px;">
                                        &nbsp;
                                        <asp:Label SkinID="DataLabel" ID="LabelZip" runat="server" Text="Postal Code:" AssociatedControlID="PostalLabel"></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label SkinID="DataLabel" ID="PostalLabel" runat="server"  Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientZip"))) %>' />
                                    </td>
                                
                                </tr> 
                            </table> 
                           </td>
                       </tr>   
                       </table>  
                </asp:Panel>

            </ItemTemplate>
                <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <EditRowStyle BackColor="#999999" />
            </asp:FormView>
            </td> 
        </tr>

        <tr>
            <td>
                <br />
            </td>
        </tr>

        <tr>
            <td>
                <asp:Panel ID="PanelLabRequest" GroupingText="&nbsp;Lab Request&nbsp;" style="width:750px;"  runat="server">
                    <br />
                    <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">
                        <tr style = "height:20px;" >
                            <td class="style3">
                                <asp:Label runat="server" ID="labelSampleType" SkinID = "DataLabel" Text="Sample Type:" AssociatedControlID="lblSampleType" Width="300px"></asp:Label></td>
                            <td>
                                <asp:Label ID="lblSampleType" SkinID = "DataLabel"  runat="server" Width="115px" ></asp:Label>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label runat="server" ID="labelLabRequestNumber" 
                                    Text="Lab Request Number:" 
                                    SkinID = "DataLabel" 
                                    AssociatedControlID="lblLabRequestNumber" 
                                    Width="300px">
                                </asp:Label></td>
                            <td>
                                <asp:Label ID="lblLabRequestNumber" SkinID = "DataLabel" runat="server" Width="115px" ></asp:Label>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td>
                                <asp:Label SkinID="DataLabel" ID="Label1LabRequestDate" runat="server" 
                                    Text="Lab Request Date (mm/dd/yyyy) * :" 
                                    AssociatedControlID="LabRequestDate">
                                </asp:Label>
                            </td>
                            <td>
                                <asp:TextBox ID="LabRequestDate" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorLabRequestDate" runat="server" 
                                    ControlToValidate="LabRequestDate"
                                    EnableClientScript="true"
                                    ValidationGroup="LabOrderValidation"
                                    ErrorMessage="Lab Request Date is required."
                                    SetFocusOnError="true">
                                </asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorLabRequestDateIsDate" runat="server" 
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ControlToValidate="LabRequestDate"
                                    ValidationGroup="LabOrderValidation"
                                    MinimumValue="1/1/1900"
                                    Type="Date"
                                    ErrorMessage="Lab Request Date must be in format (mm/dd/yyyy) and equal to or earlier than today.">
                                </asp:RangeValidator>
                                
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td>
                                <asp:Label SkinID="DataLabel" ID="LabelSampleReceivedDate" runat="server" 
                                    Text="Date Sample Received<br> at Metals Lab (mm/dd/yyyy):" 
                                    AssociatedControlID="LabSampleReceivedDate">
                                </asp:Label>
                            </td>
                            <td>
                                    
                                <asp:TextBox ID="LabSampleReceivedDate" runat="server"></asp:TextBox>
                                
                                <asp:RangeValidator ID="RangeValidatorLabelSampleReceivedDateIsDate" runat="server" 
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ControlToValidate="LabSampleReceivedDate"
                                    ValidationGroup="LabOrderValidation"
                                    MinimumValue="1/1/1900"
                                    Type="Date"
                                    ErrorMessage="Date Sample Received at Metals Lab must be equal to or earlier than today.">
                                </asp:RangeValidator>
                                
                                <asp:CompareValidator ID = "CompareValidatorLabSampleReceivedDate" runat = "server" 
                                    EnableClientScript="true"
                                    SetFocusOnError="true"
                                    ControlToValidate = "LabSampleReceivedDate" 
                                    ControlToCompare = "LabRequestDate" 
                                    Operator = "GreaterThanEqual"  
                                    ErrorMessage = "Date Sample Received at Metals Lab must be in the format (mm/dd/yyyy) and be equal or later than Lab Request Date" 
                                    Display = "Dynamic"
                                    ValidationGroup="LabOrderValidation" 
                                    Type = "Date"/>   
                                    
                           </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label runat="server" ID="LabelForLabLabelReportDate" 
                                    SkinID = "DataLabel" 
                                    Text="Lab Report Date:" 
                                    AssociatedControlID="LabelLabReportDate" 
                                    Width="300px">
                                </asp:Label></td>
                            <td>
                                <asp:Label ID="LabelLabReportDate" runat="server" 
                                    SkinID = "DataLabel" 
                                    Width="115px" >
                                </asp:Label>
                            </td>
                        </tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelBSONumber" Text="BSO Number:" AssociatedControlID="txtBSONumber"></asp:Label></td>
                            <td style="margin-left: 40px">
                                <asp:TextBox ID="txtBSONumber" runat="server" 
                                    TabIndex="30" 
                                    width="400px" 
                                    MaxLength="100">
                                </asp:TextBox>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelTrackingNumber" Text="Tracking Number:" AssociatedControlID="txtTrackingNumber"></asp:Label></td>
                            <td style="margin-left: 40px">
                                <asp:TextBox ID="txtTrackingNumber" runat="server" 
                                    TabIndex="31" 
                                    width="400px" 
                                    MaxLength="100">
                                </asp:TextBox>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label runat="server" ID="labelSampleIDNumber" SkinID = "DataLabel" Text="Sample ID Number:" AssociatedControlID="lblSampleIDNumber" Width="300px"></asp:Label></td>
                            <td>
                                <asp:Label ID="lblSampleIDNumber" SkinID = "DataLabel" runat="server" Width="115px" ></asp:Label>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3" >
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelSampleDescription" Text="Sample Description:" AssociatedControlID="txtSampleDescription"></asp:Label></td>
                            <td style="margin-left: 40px">
                                <asp:TextBox ID="txtSampleDescription" runat="server" 
                                    TabIndex="32" 
                                    width="400px" 
                                    MaxLength="100" 
                                    TextMode = "MultiLine">
                                </asp:TextBox>
                            </td>
                        </tr>
                        <tr><td colspan="2">&nbsp;</td></tr>
                        <tr style = "height:20px;">
                            <td class="style3">
                                <asp:Label SkinID="DataLabel" runat="server" ID="labelSampleInstructions" Text="Sample Instructions:" AssociatedControlID="txtSampleInstructions"></asp:Label></td>
                            <td style="margin-left: 40px">
                                <asp:TextBox ID="txtSampleInstructions" runat="server" 
                                    TabIndex="33" 
                                    width="400px" 
                                    MaxLength="100" 
                                    TextMode = "MultiLine">
                                </asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>    
           </td>
        </tr>
        <tr>
            <td>
                <br />
            </td>
        </tr>
        <tr>
            <td>
                <asp:Panel ID="PanelAnalytes" GroupingText="&nbsp;Analytes&nbsp;" style="width:750px;"  runat="server">
                <table>
                    <tr>
                        <td>
                            <asp:CheckBoxList ID ="AnalytesList" runat="server" 
                                TabIndex="34" 
                                RepeatLayout = "Table"  
                                RepeatDirection = "Horizontal" 
                                RepeatColumns = "4" 
                                CellSpacing = "5" 
                                CellPadding = "5" >            
                                <asp:ListItem Text = "Aluminum" Value = "3"></asp:ListItem>
                                <asp:ListItem Text = "Arsenic" Value = "1"></asp:ListItem>
                                <asp:ListItem Text = "Cadmium" Value = "2"></asp:ListItem>
                                <asp:ListItem Text = "Chromium" Value = "6"></asp:ListItem>
                                <asp:ListItem Text = "Cobalt" Value = "5"></asp:ListItem>
                                <asp:ListItem Text = "Copper" Value = "10"></asp:ListItem>
                                <asp:ListItem Text = "Iron" Value = "4"></asp:ListItem>
                                <asp:ListItem Text = "Lead" Value = "9"></asp:ListItem>
                                
                                <asp:ListItem Text = "Manganese" Value = "8"></asp:ListItem>  
                                <asp:ListItem Text = "Molybdenum" Value = "32"></asp:ListItem>
                                <asp:ListItem Text = "Nickel" Value = "7"></asp:ListItem>
                                <asp:ListItem Text = "Tungsten" Value = "11"></asp:ListItem>
                                <asp:ListItem Text = "Uranium" Value = "12"></asp:ListItem>
                                <asp:ListItem Text = "Uranium 235/238" Value = "13"></asp:ListItem>
                                <asp:ListItem Text = "Zinc" Value = "14"></asp:ListItem>
                                <asp:ListItem Text = "All" Value = "0"></asp:ListItem>                  
                                                                 
                            </asp:CheckBoxList>
                        

                        </td>
                    </tr>
                    <tr>
                        <td>
                            <table cellspacing="5" cellpadding="5">
                            <tr>
                                <td>
                                    <asp:CheckBox ID = "OtherAnalyteCheck" runat = "server" Text = "Other" />
                                        &nbsp;   
                                    <asp:TextBox ID = "OtherAnalyteText" runat = "server" ></asp:TextBox>
                                </td>
                            </tr>
                            </table> 
                        </td>
                    </tr>
                </table> 
                </asp:Panel> 
            </td>
        </tr>
        <tr>
            <td>
                <br />
            </td>
        </tr>
        <tr>
            <td>
                 <asp:Button ID = "SaveButton" runat = "server" 
                    TabIndex="35" 
                    UseSubmitBehavior = "true" 
                    Text = "Save" 
                    Width = "130px"                     
                    OnClick = "SaveButton_Click" />        
                 <asp:Button ID = "CompleteButton" runat="server" 
                     TabIndex="36" 
                     UseSubmitBehavior = "true" 
                     Text = "Complete" 
                     Width = "130px" 
                     ValidationGroup = "LabOrderValidation" 
                     OnClick = "CompleteButton_Click" />
                <asp:Button ID = "ReOpenLabOrder" runat =  "server" Enabled="false" 
                    TabIndex="37" 
                    UseSubmitBehavior = "true" 
                    Text = "Re-Open" 
                    Width = "130px"  
                    OnClick ="Reopen_LabOrder_Click"/>
                 <asp:Button ID = "PrintButton" runat = "server" 
                     TabIndex="38" 
                     UseSubmitBehavior = "true" 
                     Text = "Print" 
                     Width = "130px" 
                     Enabled = "false" 
                     OnClick = "PrintButton_Click"/>
                 <asp:Button ID = "VoidButton" runat = "server" 
                     TabIndex="39" 
                     UseSubmitBehavior = "true" 
                     Text = "Void" 
                     Width = "130px" 
                     OnClick = "VoidButton_Click" />
                 <asp:Button ID = "CancelButton" runat = "server" 
                     TabIndex="40" 
                     UseSubmitBehavior = "false" 
                     Text = "Cancel" 
                     Width = "130px" 
                     OnClick = "CancelButton_Click" 
                     CssClass = "cancel"  />
            </td>            
        </tr>
  </table> 
          
</asp:Content>  